#!/bin/sh

path=../../../src_plugins

sloc()
{
	(cd "$1" && sloccount .) | awk '/^Total Phys/ { size=$9; sub(",", "", size); print size }'
}

gen_pie()
{
	local bn=$1 code_size=$2 color=$3
	echo ""
	echo "@slice"
	echo "$code_size"
	echo "@label"
	echo "$bn ($code_size)"
	if test ! -z "$color"
	then
		echo "@color"
		echo "$color"
	fi
}

rm -f *.pie *.lines

echo "#autogenerated by gen.sh" > mods.pie
echo "#autogenerated by gen.sh" > after.pie

echo Core >&2
tmp=/tmp/pcb-mods-stat
mkdir $tmp
cp -r ../../../src/*.c ../../../src/*.h ../../../src/Makefile* $tmp
code_size=`sloc $tmp`
gen_pie "core" $code_size "#00ff88" >> after.pie

#echo 3rd >&2
#code_size=`sloc ../../src_3rd`
#gen_pie "3rd" $code_size >> after.pie

echo "" > classes
echo '
digraph plugin_deps {
overlap=scale
'> deps.dot

(
cat pre.html
for n in $path/*
do
	if test -d "$n"
	then
		echo $n >&2
		bn=`basename $n`
		code_size=`sloc $n`
		total=$(($total + $code_size))
		class=`cat $n/*.pup | sed '
		/^$class/ {
			s/$class *//
			s/[()]//g
			p
		}
		{ d }
		' `
		echo "$class" >> classes

		echo "$code_size" >> $class.lines
		gen_pie $bn $code_size >> $class.pie

#		case $bn in
#			gpmi) echo "@pull" >> mods.pie; echo "0.1" >> mods.pie;;
#		esac

		echo "<tr><th align=left>$bn<td>$code_size"
		cat $n/*.pup | awk -v "plugin=$n" '
		 BEGIN {
				q = "\""
				dep="/dev/fd/3"
				sub(".*/", "", plugin)
		 }
			/^[$]/ {
				key=$1
				sub("[$]", "", key)
				$1=""
				DB[key]=$0
				next
			}

			/^dep/ {
				print q plugin q "->" q $2 q >> dep
			}

			/^[A-Za-z]/ {
				key=$1
				$1=""
				DB[key]=$0
				next
			}

			function strip(s) {
				sub("^[ \t]*", "", s)
				sub("[ \t]*$", "", s)
				return s
			}

			END {
				st = DB["state"]
				if (st ~ "partial")
					clr = "bgcolor=\"yellow\""
				else if (st ~ "works")
					clr = "bgcolor=\"lightgreen\""
				else if ((st ~ "fail") || (st ~ "disable"))
					clr = "bgcolor=\"red\""
				else
					clr=""

				clr2 = clr
				if (clr2 != "") {
					sub("bgcolor=\"", "", clr2)
					sub("\"", "", clr2)
					print "@color" >> "mods.pie"
					print clr2 >> "mods.pie"
				}

				print "<td " clr " >" st
				if (DB["lstate"] != "")
					print "<br> (" strip(DB["lstate"]) ")"

				dfl = DB["default"]
				if (dfl ~ "buildin")
					clr = "bgcolor=\"lightgreen\""
				else if (dfl ~ "plugin")
					clr = "bgcolor=\"yellow\""
				else if ((dfl ~ "disable-all") || (dfl ~ "disable"))
					clr = "bgcolor=\"red\""
				else
					clr=""

				print "<td " clr ">" dfl
				if (DB["ldefault"] != "")
					print "<br> (" strip(DB["ldefault"]) ")"
				print "<td>" DB["class"]
				print "<td>" DB["long"]
				if (int(DB["autoload"]))
					print q "user" q "->" q plugin q " [color=\"#a0a0a0\"]" >> dep

				class = DB["class"]
				if (class ~ "io")
					clr = "fillcolor=\"#ffa0a0\""
				else if (class ~ "import")
					clr = "fillcolor=\"#a0ffff\""
				else if (class ~ "export")
					clr = "fillcolor=\"#a0ffff\""
				else if (class ~ "lib")
					clr = "fillcolor=\"#a0a0a0\""
				else if (class ~ "hid")
					clr = "fillcolor=\"#a0a0ff\""
				print q plugin q " [style=filled " clr "]" >> dep
			}
		'
	fi
done
cat post.html
gen_pie "plugins" "$total" "#0088ff" >> after.pie
) > index.html 3>>deps.dot
echo "}" >>deps.dot

twopi -Tsvg deps.dot > deps.svg

for n in *.lines
do
	lines=`awk '{ sum += $1 } END { print sum }' < $n`
	bn=${n%%.lines}
	gen_pie $bn $lines >> mods.pie
done


classes=`sort < classes | uniq`

for n in $classes after mods
do
	animpie < $n.pie | animator -H -d $n
	pngtopnm ${n}0000.png | pnmcrop | pnmtopng > $n.png
	rm ${n}0000.png
done


rm classes
