/*
 *   Copyright (C) 2009 Dan Vratil <vratil@progdansoft.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 3 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KOPETECONTACTS_H
#define KOPETECONTACTS_H

#include <plasma/abstractrunner.h>

#include <kicon.h>

class KopeteContactsRunner : public Plasma::AbstractRunner
{
    Q_OBJECT

    public:
        KopeteContactsRunner(QObject *parent, const QVariantList& args );
        ~KopeteContactsRunner();

        void match(Plasma::RunnerContext &context);
        void run(const Plasma::RunnerContext &context, const Plasma::QueryMatch &match);

    private:
        KIcon c_icon;
};

K_EXPORT_PLASMA_RUNNER(kopetecontacts, KopeteContactsRunner)

#endif // KOPETECONTACTS_H
