# -*- coding: utf-8 -*-
# Part of the psychopy.iohub library.
# Copyright = (C) 2012-2016 iSolver Software Solutions
# Distributed under the terms of the GNU General Public License = (GPL).
from __future__ import division, absolute_import

MODIFIERKEY_CTRL = (0x01 | 0x8000)
MODIFIERKEY_SHIFT = (0x02 | 0x8000)
MODIFIERKEY_ALT = (0x04 | 0x8000)
MODIFIERKEY_GUI = (0x08 | 0x8000)
MODIFIERKEY_LEFT_CTRL = (0x01 | 0x8000)
MODIFIERKEY_LEFT_SHIFT = (0x02 | 0x8000)
MODIFIERKEY_LEFT_ALT = (0x04 | 0x8000)
MODIFIERKEY_LEFT_GUI = (0x08 | 0x8000)
MODIFIERKEY_RIGHT_CTRL = (0x10 | 0x8000)
MODIFIERKEY_RIGHT_SHIFT = (0x20 | 0x8000)
MODIFIERKEY_RIGHT_ALT = (0x40 | 0x8000)
MODIFIERKEY_RIGHT_GUI = (0x80 | 0x8000)

KEY_MEDIA_VOLUME_INC = 0x01
KEY_MEDIA_VOLUME_DEC = 0x02
KEY_MEDIA_MUTE = 0x04
KEY_MEDIA_PLAY_PAUSE = 0x08
KEY_MEDIA_NEXT_TRACK = 0x10
KEY_MEDIA_PREV_TRACK = 0x20
KEY_MEDIA_STOP = 0x40
KEY_MEDIA_EJECT = 0x80

KEY_A = (4 | 0x4000)
KEY_B = (5 | 0x4000)
KEY_C = (6 | 0x4000)
KEY_D = (7 | 0x4000)
KEY_E = (8 | 0x4000)
KEY_F = (9 | 0x4000)
KEY_G = (10 | 0x4000)
KEY_H = (11 | 0x4000)
KEY_I = (12 | 0x4000)
KEY_J = (13 | 0x4000)
KEY_K = (14 | 0x4000)
KEY_L = (15 | 0x4000)
KEY_M = (16 | 0x4000)
KEY_N = (17 | 0x4000)
KEY_O = (18 | 0x4000)
KEY_P = (19 | 0x4000)
KEY_Q = (20 | 0x4000)
KEY_R = (21 | 0x4000)
KEY_S = (22 | 0x4000)
KEY_T = (23 | 0x4000)
KEY_U = (24 | 0x4000)
KEY_V = (25 | 0x4000)
KEY_W = (26 | 0x4000)
KEY_X = (27 | 0x4000)
KEY_Y = (28 | 0x4000)
KEY_Z = (29 | 0x4000)
KEY_1 = (30 | 0x4000)
KEY_2 = (31 | 0x4000)
KEY_3 = (32 | 0x4000)
KEY_4 = (33 | 0x4000)
KEY_5 = (34 | 0x4000)
KEY_6 = (35 | 0x4000)
KEY_7 = (36 | 0x4000)
KEY_8 = (37 | 0x4000)
KEY_9 = (38 | 0x4000)
KEY_0 = (39 | 0x4000)
KEY_ENTER = (40 | 0x4000)
KEY_ESC = (41 | 0x4000)
KEY_BACKSPACE = (42 | 0x4000)
KEY_TAB = (43 | 0x4000)
KEY_SPACE = (44 | 0x4000)
KEY_MINUS = (45 | 0x4000)
KEY_EQUAL = (46 | 0x4000)
KEY_LEFT_BRACE = (47 | 0x4000)
KEY_RIGHT_BRACE = (48 | 0x4000)
KEY_BACKSLASH = (49 | 0x4000)
KEY_NON_US_NUM = (50 | 0x4000)
KEY_SEMICOLON = (51 | 0x4000)
KEY_QUOTE = (52 | 0x4000)
KEY_TILDE = (53 | 0x4000)
KEY_COMMA = (54 | 0x4000)
KEY_PERIOD = (55 | 0x4000)
KEY_SLASH = (56 | 0x4000)
KEY_CAPS_LOCK = (57 | 0x4000)
KEY_F1 = (58 | 0x4000)
KEY_F2 = (59 | 0x4000)
KEY_F3 = (60 | 0x4000)
KEY_F4 = (61 | 0x4000)
KEY_F5 = (62 | 0x4000)
KEY_F6 = (63 | 0x4000)
KEY_F7 = (64 | 0x4000)
KEY_F8 = (65 | 0x4000)
KEY_F9 = (66 | 0x4000)
KEY_F10 = (67 | 0x4000)
KEY_F11 = (68 | 0x4000)
KEY_F12 = (69 | 0x4000)
KEY_PRINTSCREEN = (70 | 0x4000)
KEY_SCROLL_LOCK = (71 | 0x4000)
KEY_PAUSE = (72 | 0x4000)
KEY_INSERT = (73 | 0x4000)
KEY_HOME = (74 | 0x4000)
KEY_PAGE_UP = (75 | 0x4000)
KEY_DELETE = (76 | 0x4000)
KEY_END = (77 | 0x4000)
KEY_PAGE_DOWN = (78 | 0x4000)
KEY_RIGHT = (79 | 0x4000)
KEY_LEFT = (80 | 0x4000)
KEY_DOWN = (81 | 0x4000)
KEY_UP = (82 | 0x4000)
KEY_NUM_LOCK = (83 | 0x4000)
KEYPAD_SLASH = (84 | 0x4000)
KEYPAD_ASTERIX = (85 | 0x4000)
KEYPAD_MINUS = (86 | 0x4000)
KEYPAD_PLUS = (87 | 0x4000)
KEYPAD_ENTER = (88 | 0x4000)
KEYPAD_1 = (89 | 0x4000)
KEYPAD_2 = (90 | 0x4000)
KEYPAD_3 = (91 | 0x4000)
KEYPAD_4 = (92 | 0x4000)
KEYPAD_5 = (93 | 0x4000)
KEYPAD_6 = (94 | 0x4000)
KEYPAD_7 = (95 | 0x4000)
KEYPAD_8 = (96 | 0x4000)
KEYPAD_9 = (97 | 0x4000)
KEYPAD_0 = (98 | 0x4000)
KEYPAD_PERIOD = (99 | 0x4000)
KEY_MENU = (101 | 0x4000)
KEY_F13 = (104 | 0x4000)
KEY_F14 = (105 | 0x4000)
KEY_F15 = (106 | 0x4000)
KEY_F16 = (107 | 0x4000)
KEY_F17 = (108 | 0x4000)
KEY_F18 = (109 | 0x4000)
KEY_F19 = (110 | 0x4000)
KEY_F20 = (111 | 0x4000)
KEY_F21 = (112 | 0x4000)
KEY_F22 = (113 | 0x4000)
KEY_F23 = (114 | 0x4000)
KEY_F24 = (115 | 0x4000)

char2t3code = dict()
char2t3code['a'] = KEY_A
char2t3code['b'] = KEY_B
char2t3code['c'] = KEY_C
char2t3code['d'] = KEY_D
char2t3code['e'] = KEY_E
char2t3code['f'] = KEY_F
char2t3code['g'] = KEY_G
char2t3code['h'] = KEY_H
char2t3code['i'] = KEY_I
char2t3code['j'] = KEY_J
char2t3code['k'] = KEY_K
char2t3code['l'] = KEY_L
char2t3code['m'] = KEY_M
char2t3code['n'] = KEY_N
char2t3code['o'] = KEY_O
char2t3code['p'] = KEY_P
char2t3code['q'] = KEY_Q
char2t3code['r'] = KEY_R
char2t3code['s'] = KEY_S
char2t3code['t'] = KEY_T
char2t3code['u'] = KEY_U
char2t3code['v'] = KEY_V
char2t3code['w'] = KEY_W
char2t3code['x'] = KEY_X
char2t3code['y'] = KEY_Y
char2t3code['z'] = KEY_Z
char2t3code['1'] = KEY_1
char2t3code['2'] = KEY_2
char2t3code['3'] = KEY_3
char2t3code['4'] = KEY_4
char2t3code['5'] = KEY_5
char2t3code['6'] = KEY_6
char2t3code['7'] = KEY_7
char2t3code['8'] = KEY_8
char2t3code['9'] = KEY_9
char2t3code['0'] = KEY_0
char2t3code['return'] = KEY_ENTER
char2t3code['enter'] = KEY_ENTER
char2t3code['escape'] = KEY_ESC
char2t3code['backspace'] = KEY_BACKSPACE
char2t3code['tab'] = KEY_TAB
char2t3code[' '] = KEY_SPACE
char2t3code['-'] = KEY_MINUS
char2t3code['='] = KEY_EQUAL
char2t3code['['] = KEY_LEFT_BRACE
char2t3code[']'] = KEY_RIGHT_BRACE
char2t3code['\\'] = KEY_BACKSLASH
# TODO??? char2t3code[''] = KEY_NON_US_NUM
char2t3code[';'] = KEY_SEMICOLON
char2t3code['"'] = KEY_QUOTE
char2t3code['`'] = KEY_TILDE
char2t3code[','] = KEY_COMMA
char2t3code['.'] = KEY_PERIOD
char2t3code['/'] = KEY_SLASH
char2t3code['capslock'] = KEY_CAPS_LOCK
char2t3code['f1'] = KEY_F1
char2t3code['f2'] = KEY_F2
char2t3code['f3'] = KEY_F3
char2t3code['f4'] = KEY_F4
char2t3code['f5'] = KEY_F5
char2t3code['f6'] = KEY_F6
char2t3code['f7'] = KEY_F7
char2t3code['f8'] = KEY_F8
char2t3code['f9'] = KEY_F9
char2t3code['f10'] = KEY_F10
char2t3code['f11'] = KEY_F11
char2t3code['f12'] = KEY_F12
char2t3code['print_screen'] = KEY_PRINTSCREEN
char2t3code['scrolllock'] = KEY_SCROLL_LOCK
char2t3code['pause'] = KEY_PAUSE
char2t3code['insert'] = KEY_INSERT
char2t3code['home'] = KEY_HOME
char2t3code['pageup'] = KEY_PAGE_UP
char2t3code['delete'] = KEY_DELETE
char2t3code['end'] = KEY_END
char2t3code['pagedown'] = KEY_PAGE_DOWN
char2t3code['right'] = KEY_RIGHT
char2t3code['left'] = KEY_LEFT
char2t3code['down'] = KEY_DOWN
char2t3code['up'] = KEY_UP
char2t3code['numlock'] = KEY_NUM_LOCK
char2t3code['kp_/'] = KEYPAD_SLASH
char2t3code['kp_*'] = KEYPAD_ASTERIX
char2t3code['kp_-'] = KEYPAD_MINUS
char2t3code['kp_+'] = KEYPAD_PLUS
char2t3code['kp_return'] = KEYPAD_ENTER
char2t3code['kp_enter'] = KEYPAD_ENTER
char2t3code['kp_1'] = KEYPAD_1
char2t3code['kp_2'] = KEYPAD_2
char2t3code['kp_3'] = KEYPAD_3
char2t3code['kp_4'] = KEYPAD_4
char2t3code['kp_5'] = KEYPAD_5
char2t3code['kp_6'] = KEYPAD_6
char2t3code['kp_7'] = KEYPAD_7
char2t3code['kp_8'] = KEYPAD_8
char2t3code['kp_9'] = KEYPAD_9
char2t3code['kp_0'] = KEYPAD_0
char2t3code['kp_.'] = KEYPAD_PERIOD
char2t3code['menu'] = KEY_MENU
char2t3code['f13'] = KEY_F13
char2t3code['f14'] = KEY_F14
char2t3code['f15'] = KEY_F15
char2t3code['f16'] = KEY_F16
char2t3code['f17'] = KEY_F17
char2t3code['f18'] = KEY_F18
char2t3code['f19'] = KEY_F19
char2t3code['f20'] = KEY_F20
char2t3code['f21'] = KEY_F21
char2t3code['f22'] = KEY_F22
char2t3code['f23'] = KEY_F23
char2t3code['f24'] = KEY_F24

char2t3code['media_volume_inc'] = KEY_MEDIA_VOLUME_INC
char2t3code['media_volume_dec'] = KEY_MEDIA_VOLUME_DEC
char2t3code['media_mute'] = KEY_MEDIA_MUTE
char2t3code['media_play_pause'] = KEY_MEDIA_PLAY_PAUSE
char2t3code['media_next_track'] = KEY_MEDIA_NEXT_TRACK
char2t3code['media_prev_track'] = KEY_MEDIA_PREV_TRACK
char2t3code['media_stop'] = KEY_MEDIA_STOP
char2t3code['media_eject'] = KEY_MEDIA_EJECT

mod2t3code = dict()
mod2t3code['ctrl'] = MODIFIERKEY_CTRL
mod2t3code['shift'] = MODIFIERKEY_SHIFT
mod2t3code['alt'] = MODIFIERKEY_ALT
mod2t3code['gui'] = MODIFIERKEY_GUI
mod2t3code['windows'] = MODIFIERKEY_GUI
mod2t3code['lctrl'] = MODIFIERKEY_LEFT_CTRL
mod2t3code['lshift'] = MODIFIERKEY_LEFT_SHIFT
mod2t3code['lalt'] = MODIFIERKEY_LEFT_ALT
mod2t3code['lgui'] = MODIFIERKEY_LEFT_GUI
mod2t3code['lwindows'] = MODIFIERKEY_LEFT_GUI
mod2t3code['rctrl'] = MODIFIERKEY_RIGHT_CTRL
mod2t3code['rshift'] = MODIFIERKEY_RIGHT_SHIFT
mod2t3code['ralt'] = MODIFIERKEY_RIGHT_ALT
mod2t3code['rgui'] = MODIFIERKEY_RIGHT_GUI
mod2t3code['rwindows'] = MODIFIERKEY_RIGHT_GUI
