# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the action to take on rule match."""

    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"


class AfdCertificateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the source of the SSL certificate."""

    CUSTOMER_CERTIFICATE = "CustomerCertificate"
    MANAGED_CERTIFICATE = "ManagedCertificate"
    AZURE_FIRST_PARTY_MANAGED_CERTIFICATE = "AzureFirstPartyManagedCertificate"


class AFDEndpointProtocols(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported protocols for the customer's endpoint."""

    HTTP = "Http"
    HTTPS = "Https"


class AfdMinimumTlsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TLS protocol version that will be used for Https."""

    TLS10 = "TLS10"
    TLS12 = "TLS12"


class AfdProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"


class AfdQueryStringCachingBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines how Frontdoor caches requests that include query strings. You can ignore any query
    strings when caching, ignore specific query strings, cache every request with a unique URL, or
    cache specific query strings.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    USE_QUERY_STRING = "UseQueryString"
    IGNORE_SPECIFIED_QUERY_STRINGS = "IgnoreSpecifiedQueryStrings"
    INCLUDE_SPECIFIED_QUERY_STRINGS = "IncludeSpecifiedQueryStrings"


class Algorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Algorithm to use for URL signing."""

    SHA256 = "SHA256"


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the endpoint name reuse scope. The default value is TenantReuse."""

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"


class CacheBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Caching behavior for the requests."""

    BYPASS_CACHE = "BypassCache"
    OVERRIDE = "Override"
    SET_IF_MISSING = "SetIfMissing"


class CacheExpirationActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CacheExpirationActionParametersTypeName."""

    DELIVERY_RULE_CACHE_EXPIRATION_ACTION_PARAMETERS = "DeliveryRuleCacheExpirationActionParameters"


class CacheKeyQueryStringActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CacheKeyQueryStringActionParametersTypeName."""

    DELIVERY_RULE_CACHE_KEY_QUERY_STRING_BEHAVIOR_ACTION_PARAMETERS = (
        "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"
    )


class CacheType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The level at which the content needs to be cached."""

    ALL = "All"


class CdnCertificateSourceParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CdnCertificateSourceParametersTypeName."""

    CDN_CERTIFICATE_SOURCE_PARAMETERS = "CdnCertificateSourceParameters"


class CertificateSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the source of the SSL certificate."""

    AZURE_KEY_VAULT = "AzureKeyVault"
    CDN = "Cdn"


class CertificateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of certificate used."""

    SHARED = "Shared"
    DEDICATED = "Dedicated"


class ClientPortMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ClientPortMatchConditionParametersTypeName."""

    DELIVERY_RULE_CLIENT_PORT_CONDITION_PARAMETERS = "DeliveryRuleClientPortConditionParameters"


class ClientPortOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class CookiesMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CookiesMatchConditionParametersTypeName."""

    DELIVERY_RULE_COOKIES_CONDITION_PARAMETERS = "DeliveryRuleCookiesConditionParameters"


class CookiesOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class CustomDomainResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the custom domain."""

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"


class CustomHttpsProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the custom domain."""

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    FAILED = "Failed"


class CustomHttpsProvisioningSubstate(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step.
    """

    SUBMITTING_DOMAIN_CONTROL_VALIDATION_REQUEST = "SubmittingDomainControlValidationRequest"
    PENDING_DOMAIN_CONTROL_VALIDATION_R_EQUEST_APPROVAL = "PendingDomainControlValidationREquestApproval"
    DOMAIN_CONTROL_VALIDATION_REQUEST_APPROVED = "DomainControlValidationRequestApproved"
    DOMAIN_CONTROL_VALIDATION_REQUEST_REJECTED = "DomainControlValidationRequestRejected"
    DOMAIN_CONTROL_VALIDATION_REQUEST_TIMED_OUT = "DomainControlValidationRequestTimedOut"
    ISSUING_CERTIFICATE = "IssuingCertificate"
    DEPLOYING_CERTIFICATE = "DeployingCertificate"
    CERTIFICATE_DEPLOYED = "CertificateDeployed"
    DELETING_CERTIFICATE = "DeletingCertificate"
    CERTIFICATE_DELETED = "CertificateDeleted"


class CustomRuleEnabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DeleteRule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the action that shall be taken when the certificate is removed from Key Vault."""

    NO_ACTION = "NoAction"


class DeliveryRuleActionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the action for the delivery rule."""

    CACHE_EXPIRATION = "CacheExpiration"
    CACHE_KEY_QUERY_STRING = "CacheKeyQueryString"
    MODIFY_REQUEST_HEADER = "ModifyRequestHeader"
    MODIFY_RESPONSE_HEADER = "ModifyResponseHeader"
    URL_REDIRECT = "UrlRedirect"
    URL_REWRITE = "UrlRewrite"
    URL_SIGNING = "UrlSigning"
    ORIGIN_GROUP_OVERRIDE = "OriginGroupOverride"
    ROUTE_CONFIGURATION_OVERRIDE = "RouteConfigurationOverride"


class DeploymentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DeploymentStatus."""

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class DestinationProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol to use for the redirect. The default value is MatchRequest."""

    MATCH_REQUEST = "MatchRequest"
    HTTP = "Http"
    HTTPS = "Https"


class DomainValidationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step. DCV stands for DomainControlValidation.
    """

    UNKNOWN = "Unknown"
    SUBMITTING = "Submitting"
    PENDING = "Pending"
    REJECTED = "Rejected"
    TIMED_OUT = "TimedOut"
    PENDING_REVALIDATION = "PendingRevalidation"
    APPROVED = "Approved"
    REFRESHING_VALIDATION_TOKEN = "RefreshingValidationToken"
    INTERNAL_ERROR = "InternalError"


class EnabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class EndpointProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the endpoint."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"


class EndpointResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the endpoint."""

    CREATING = "Creating"
    DELETING = "Deleting"
    RUNNING = "Running"
    STARTING = "Starting"
    STOPPED = "Stopped"
    STOPPING = "Stopping"


class ForwardingProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol this rule will use when forwarding traffic to backends."""

    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"


class GeoFilterActions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action of the geo filter, i.e. allow or block access."""

    BLOCK = "Block"
    ALLOW = "Allow"


class HeaderAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action to perform."""

    APPEND = "Append"
    OVERWRITE = "Overwrite"
    DELETE = "Delete"


class HeaderActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HeaderActionParametersTypeName."""

    DELIVERY_RULE_HEADER_ACTION_PARAMETERS = "DeliveryRuleHeaderActionParameters"


class HealthProbeRequestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of health probe request that is made."""

    NOT_SET = "NotSet"
    GET = "GET"
    HEAD = "HEAD"


class HostNameMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HostNameMatchConditionParametersTypeName."""

    DELIVERY_RULE_HOST_NAME_CONDITION_PARAMETERS = "DeliveryRuleHostNameConditionParameters"


class HostNameOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class HttpsRedirect(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way
    to set up this rule and it will be the first rule that gets executed.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class HttpVersionMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HttpVersionMatchConditionParametersTypeName."""

    DELIVERY_RULE_HTTP_VERSION_CONDITION_PARAMETERS = "DeliveryRuleHttpVersionConditionParameters"


class HttpVersionOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    EQUAL = "Equal"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that creates/modifies resources."""

    USER = "user"
    APPLICATION = "application"
    MANAGED_IDENTITY = "managedIdentity"
    KEY = "key"


class IsDeviceMatchConditionParametersMatchValuesItem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IsDeviceMatchConditionParametersMatchValuesItem."""

    MOBILE = "Mobile"
    DESKTOP = "Desktop"


class IsDeviceMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IsDeviceMatchConditionParametersTypeName."""

    DELIVERY_RULE_IS_DEVICE_CONDITION_PARAMETERS = "DeliveryRuleIsDeviceConditionParameters"


class IsDeviceOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    EQUAL = "Equal"


class KeyVaultCertificateSourceParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """KeyVaultCertificateSourceParametersTypeName."""

    KEY_VAULT_CERTIFICATE_SOURCE_PARAMETERS = "KeyVaultCertificateSourceParameters"


class KeyVaultSigningKeyParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """KeyVaultSigningKeyParametersTypeName."""

    KEY_VAULT_SIGNING_KEY_PARAMETERS = "KeyVaultSigningKeyParameters"


class LinkToDefaultDomain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """whether this route will be linked to the default endpoint domain."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class LogMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LogMetric."""

    CLIENT_REQUEST_COUNT = "clientRequestCount"
    CLIENT_REQUEST_TRAFFIC = "clientRequestTraffic"
    CLIENT_REQUEST_BANDWIDTH = "clientRequestBandwidth"
    ORIGIN_REQUEST_TRAFFIC = "originRequestTraffic"
    ORIGIN_REQUEST_BANDWIDTH = "originRequestBandwidth"
    TOTAL_LATENCY = "totalLatency"


class LogMetricsGranularity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LogMetricsGranularity."""

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"


class LogMetricsGroupBy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LogMetricsGroupBy."""

    HTTP_STATUS_CODE = "httpStatusCode"
    PROTOCOL = "protocol"
    CACHE_STATUS = "cacheStatus"
    COUNTRY_OR_REGION = "countryOrRegion"
    CUSTOM_DOMAIN = "customDomain"


class LogRanking(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LogRanking."""

    URL = "url"
    REFERRER = "referrer"
    BROWSER = "browser"
    USER_AGENT = "userAgent"
    COUNTRY_OR_REGION = "countryOrRegion"


class LogRankingMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LogRankingMetric."""

    CLIENT_REQUEST_COUNT = "clientRequestCount"
    CLIENT_REQUEST_TRAFFIC = "clientRequestTraffic"
    HIT_COUNT = "hitCount"
    MISS_COUNT = "missCount"
    USER_ERROR_COUNT = "userErrorCount"
    ERROR_COUNT = "errorCount"


class ManagedRuleEnabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class MatchProcessingBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If this rule is a match should the rules engine continue running the remaining rules or stop.
    If not present, defaults to Continue.
    """

    CONTINUE = "Continue"
    STOP = "Stop"


class MatchVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the condition for the delivery rule."""

    REMOTE_ADDRESS = "RemoteAddress"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    REQUEST_SCHEME = "RequestScheme"
    URL_PATH = "UrlPath"
    URL_FILE_EXTENSION = "UrlFileExtension"
    URL_FILE_NAME = "UrlFileName"
    HTTP_VERSION = "HttpVersion"
    COOKIES = "Cookies"
    IS_DEVICE = "IsDevice"
    SOCKET_ADDR = "SocketAddr"
    CLIENT_PORT = "ClientPort"
    SERVER_PORT = "ServerPort"
    HOST_NAME = "HostName"
    SSL_PROTOCOL = "SslProtocol"


class MetricsResponseGranularity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MetricsResponseGranularity."""

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"


class MetricsResponseSeriesItemUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MetricsResponseSeriesItemUnit."""

    COUNT = "count"
    BYTES = "bytes"
    BITS_PER_SECOND = "bitsPerSecond"
    MILLI_SECONDS = "milliSeconds"


class MinimumTlsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TLS protocol version that will be used for Https."""

    NONE = "None"
    TLS10 = "TLS10"
    TLS12 = "TLS12"


class Operator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REG_EX = "RegEx"


class OptimizationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies what scenario the customer wants this CDN endpoint to optimize, e.g. Download, Media
    services. With this information we can apply scenario driven optimization.
    """

    GENERAL_WEB_DELIVERY = "GeneralWebDelivery"
    GENERAL_MEDIA_STREAMING = "GeneralMediaStreaming"
    VIDEO_ON_DEMAND_MEDIA_STREAMING = "VideoOnDemandMediaStreaming"
    LARGE_FILE_DOWNLOAD = "LargeFileDownload"
    DYNAMIC_SITE_ACCELERATION = "DynamicSiteAcceleration"


class OriginGroupOverrideActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OriginGroupOverrideActionParametersTypeName."""

    DELIVERY_RULE_ORIGIN_GROUP_OVERRIDE_ACTION_PARAMETERS = "DeliveryRuleOriginGroupOverrideActionParameters"


class OriginGroupProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the origin group."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"


class OriginGroupResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the origin group."""

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"


class OriginProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the origin."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"


class OriginResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the origin."""

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"


class ParamIndicator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the purpose of the parameter."""

    EXPIRES = "Expires"
    KEY_ID = "KeyId"
    SIGNATURE = "Signature"


class PolicyEnabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """describes if the policy is in enabled state or disabled state."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class PolicyMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if it is in detection mode or prevention mode at policy level."""

    PREVENTION = "Prevention"
    DETECTION = "Detection"


class PolicyResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the policy."""

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"


class PolicySettingsDefaultCustomBlockResponseStatusCode(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If the action type is block, this field defines the default customer overridable http response
    status code.
    """

    TWO_HUNDRED = 200
    FOUR_HUNDRED_THREE = 403
    FOUR_HUNDRED_FIVE = 405
    FOUR_HUNDRED_SIX = 406
    FOUR_HUNDRED_TWENTY_NINE = 429


class PostArgsMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PostArgsMatchConditionParametersTypeName."""

    DELIVERY_RULE_POST_ARGS_CONDITION_PARAMETERS = "DeliveryRulePostArgsConditionParameters"


class PostArgsOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class PrivateEndpointStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The approval status for the connection to the Private Link."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"


class ProbeProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol to use for health probe."""

    NOT_SET = "NotSet"
    HTTP = "Http"
    HTTPS = "Https"


class ProfileProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning status of the profile."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"


class ProfileResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource status of the profile."""

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DISABLED = "Disabled"


class ProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the TLS extension protocol that is used for secure delivery."""

    SERVER_NAME_INDICATION = "ServerNameIndication"
    IP_BASED = "IPBased"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the WebApplicationFirewallPolicy."""

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class QueryStringBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Caching behavior for the requests."""

    INCLUDE = "Include"
    INCLUDE_ALL = "IncludeAll"
    EXCLUDE = "Exclude"
    EXCLUDE_ALL = "ExcludeAll"


class QueryStringCachingBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines how CDN caches requests that include query strings. You can ignore any query strings
    when caching, bypass caching to prevent requests that contain query strings from being cached,
    or cache every request with a unique URL.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    BYPASS_CACHING = "BypassCaching"
    USE_QUERY_STRING = "UseQueryString"
    NOT_SET = "NotSet"


class QueryStringMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """QueryStringMatchConditionParametersTypeName."""

    DELIVERY_RULE_QUERY_STRING_CONDITION_PARAMETERS = "DeliveryRuleQueryStringConditionParameters"


class QueryStringOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class RedirectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The redirect type the rule will use when redirecting traffic."""

    MOVED = "Moved"
    FOUND = "Found"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"


class RemoteAddressMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RemoteAddressMatchConditionParametersTypeName."""

    DELIVERY_RULE_REMOTE_ADDRESS_CONDITION_PARAMETERS = "DeliveryRuleRemoteAddressConditionParameters"


class RemoteAddressOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"


class RequestBodyMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestBodyMatchConditionParametersTypeName."""

    DELIVERY_RULE_REQUEST_BODY_CONDITION_PARAMETERS = "DeliveryRuleRequestBodyConditionParameters"


class RequestBodyOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class RequestHeaderMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestHeaderMatchConditionParametersTypeName."""

    DELIVERY_RULE_REQUEST_HEADER_CONDITION_PARAMETERS = "DeliveryRuleRequestHeaderConditionParameters"


class RequestHeaderOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class RequestMethodMatchConditionParametersMatchValuesItem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestMethodMatchConditionParametersMatchValuesItem."""

    GET = "GET"
    HEAD = "HEAD"
    POST = "POST"
    PUT = "PUT"
    DELETE = "DELETE"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"


class RequestMethodMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestMethodMatchConditionParametersTypeName."""

    DELIVERY_RULE_REQUEST_METHOD_CONDITION_PARAMETERS = "DeliveryRuleRequestMethodConditionParameters"


class RequestMethodOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    EQUAL = "Equal"


class RequestSchemeMatchConditionParametersMatchValuesItem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestSchemeMatchConditionParametersMatchValuesItem."""

    HTTP = "HTTP"
    HTTPS = "HTTPS"


class RequestSchemeMatchConditionParametersOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    EQUAL = "Equal"


class RequestSchemeMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestSchemeMatchConditionParametersTypeName."""

    DELIVERY_RULE_REQUEST_SCHEME_CONDITION_PARAMETERS = "DeliveryRuleRequestSchemeConditionParameters"


class RequestUriMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RequestUriMatchConditionParametersTypeName."""

    DELIVERY_RULE_REQUEST_URI_CONDITION_PARAMETERS = "DeliveryRuleRequestUriConditionParameters"


class RequestUriOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class ResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of CDN resource used in CheckNameAvailability."""

    MICROSOFT_CDN_PROFILES_ENDPOINTS = "Microsoft.Cdn/Profiles/Endpoints"
    MICROSOFT_CDN_PROFILES_AFD_ENDPOINTS = "Microsoft.Cdn/Profiles/AfdEndpoints"


class ResourceUsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Unit of the usage. e.g. count."""

    COUNT = "count"


class ResponseBasedDetectedErrorTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of response errors for real user requests for which origin will be deemed unhealthy."""

    NONE = "None"
    TCP_ERRORS_ONLY = "TcpErrorsOnly"
    TCP_AND_HTTP_ERRORS = "TcpAndHttpErrors"


class RouteConfigurationOverrideActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RouteConfigurationOverrideActionParametersTypeName."""

    DELIVERY_RULE_ROUTE_CONFIGURATION_OVERRIDE_ACTION_PARAMETERS = (
        "DeliveryRuleRouteConfigurationOverrideActionParameters"
    )


class RuleCacheBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Caching behavior for the requests."""

    HONOR_ORIGIN = "HonorOrigin"
    OVERRIDE_ALWAYS = "OverrideAlways"
    OVERRIDE_IF_ORIGIN_MISSING = "OverrideIfOriginMissing"


class RuleIsCompressionEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether content compression is enabled. If compression is enabled, content will be
    served as compressed if user requests for a compressed version. Content won't be compressed on
    AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RuleQueryStringCachingBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines how Frontdoor caches requests that include query strings. You can ignore any query
    strings when caching, ignore specific query strings, cache every request with a unique URL, or
    cache specific query strings.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    USE_QUERY_STRING = "UseQueryString"
    IGNORE_SPECIFIED_QUERY_STRINGS = "IgnoreSpecifiedQueryStrings"
    INCLUDE_SPECIFIED_QUERY_STRINGS = "IncludeSpecifiedQueryStrings"


class SecretType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the secret resource."""

    URL_SIGNING_KEY = "UrlSigningKey"
    CUSTOMER_CERTIFICATE = "CustomerCertificate"
    MANAGED_CERTIFICATE = "ManagedCertificate"
    AZURE_FIRST_PARTY_MANAGED_CERTIFICATE = "AzureFirstPartyManagedCertificate"


class SecurityPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the Security policy to create."""

    WEB_APPLICATION_FIREWALL = "WebApplicationFirewall"


class ServerPortMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ServerPortMatchConditionParametersTypeName."""

    DELIVERY_RULE_SERVER_PORT_CONDITION_PARAMETERS = "DeliveryRuleServerPortConditionParameters"


class ServerPortOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class SharedPrivateLinkResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected,
    or Timeout.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the pricing tier."""

    STANDARD_VERIZON = "Standard_Verizon"
    PREMIUM_VERIZON = "Premium_Verizon"
    CUSTOM_VERIZON = "Custom_Verizon"
    STANDARD_AKAMAI = "Standard_Akamai"
    STANDARD_CHINA_CDN = "Standard_ChinaCdn"
    STANDARD_MICROSOFT = "Standard_Microsoft"
    STANDARD_AZURE_FRONT_DOOR = "Standard_AzureFrontDoor"
    PREMIUM_AZURE_FRONT_DOOR = "Premium_AzureFrontDoor"
    STANDARD955_BAND_WIDTH_CHINA_CDN = "Standard_955BandWidth_ChinaCdn"
    STANDARD_AVG_BAND_WIDTH_CHINA_CDN = "Standard_AvgBandWidth_ChinaCdn"
    STANDARD_PLUS_CHINA_CDN = "StandardPlus_ChinaCdn"
    STANDARD_PLUS955_BAND_WIDTH_CHINA_CDN = "StandardPlus_955BandWidth_ChinaCdn"
    STANDARD_PLUS_AVG_BAND_WIDTH_CHINA_CDN = "StandardPlus_AvgBandWidth_ChinaCdn"


class SocketAddrMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SocketAddrMatchConditionParametersTypeName."""

    DELIVERY_RULE_SOCKET_ADDR_CONDITION_PARAMETERS = "DeliveryRuleSocketAddrConditionParameters"


class SocketAddrOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    IP_MATCH = "IPMatch"


class SslProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The protocol of an established TLS connection."""

    TL_SV1 = "TLSv1"
    TL_SV1_1 = "TLSv1.1"
    TL_SV1_2 = "TLSv1.2"


class SslProtocolMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SslProtocolMatchConditionParametersTypeName."""

    DELIVERY_RULE_SSL_PROTOCOL_CONDITION_PARAMETERS = "DeliveryRuleSslProtocolConditionParameters"


class SslProtocolOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    EQUAL = "Equal"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The validation status."""

    VALID = "Valid"
    INVALID = "Invalid"
    ACCESS_DENIED = "AccessDenied"
    CERTIFICATE_EXPIRED = "CertificateExpired"


class Transform(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes what transforms are applied before matching."""

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"


class TransformType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes what transforms were applied before matching."""

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"


class UpdateRule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the action that shall be taken when the certificate is updated in Key Vault."""

    NO_ACTION = "NoAction"


class UrlFileExtensionMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UrlFileExtensionMatchConditionParametersTypeName."""

    DELIVERY_RULE_URL_FILE_EXTENSION_MATCH_CONDITION_PARAMETERS = "DeliveryRuleUrlFileExtensionMatchConditionParameters"


class UrlFileExtensionOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class UrlFileNameMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UrlFileNameMatchConditionParametersTypeName."""

    DELIVERY_RULE_URL_FILENAME_CONDITION_PARAMETERS = "DeliveryRuleUrlFilenameConditionParameters"


class UrlFileNameOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"


class UrlPathMatchConditionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UrlPathMatchConditionParametersTypeName."""

    DELIVERY_RULE_URL_PATH_MATCH_CONDITION_PARAMETERS = "DeliveryRuleUrlPathMatchConditionParameters"


class UrlPathOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes operator to be matched."""

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    WILDCARD = "Wildcard"
    REG_EX = "RegEx"


class UrlRedirectActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UrlRedirectActionParametersTypeName."""

    DELIVERY_RULE_URL_REDIRECT_ACTION_PARAMETERS = "DeliveryRuleUrlRedirectActionParameters"


class UrlRewriteActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UrlRewriteActionParametersTypeName."""

    DELIVERY_RULE_URL_REWRITE_ACTION_PARAMETERS = "DeliveryRuleUrlRewriteActionParameters"


class UrlSigningActionParametersTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UrlSigningActionParametersTypeName."""

    DELIVERY_RULE_URL_SIGNING_ACTION_PARAMETERS = "DeliveryRuleUrlSigningActionParameters"


class UsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An enum describing the unit of measurement."""

    COUNT = "Count"


class WafAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafAction."""

    ALLOW = "allow"
    BLOCK = "block"
    LOG = "log"
    REDIRECT = "redirect"


class WafGranularity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafGranularity."""

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"


class WafMatchVariable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Match variable to compare against."""

    REMOTE_ADDR = "RemoteAddr"
    SOCKET_ADDR = "SocketAddr"
    REQUEST_METHOD = "RequestMethod"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_URI = "RequestUri"
    QUERY_STRING = "QueryString"
    REQUEST_BODY = "RequestBody"
    COOKIES = "Cookies"
    POST_ARGS = "PostArgs"


class WafMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafMetric."""

    CLIENT_REQUEST_COUNT = "clientRequestCount"


class WafMetricsResponseGranularity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafMetricsResponseGranularity."""

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"


class WafMetricsResponseSeriesItemUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafMetricsResponseSeriesItemUnit."""

    COUNT = "count"


class WafRankingGroupBy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafRankingGroupBy."""

    HTTP_STATUS_CODE = "httpStatusCode"
    CUSTOM_DOMAIN = "customDomain"


class WafRankingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafRankingType."""

    ACTION = "action"
    RULE_GROUP = "ruleGroup"
    RULE_ID = "ruleId"
    USER_AGENT = "userAgent"
    CLIENT_IP = "clientIp"
    URL = "url"
    COUNTRY_OR_REGION = "countryOrRegion"
    RULE_TYPE = "ruleType"


class WafRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WafRuleType."""

    MANAGED = "managed"
    CUSTOM = "custom"
    BOT = "bot"
